<?php
require_once("../layouts/members/head.php");

if ($user_data['eid_Status_service'] == "YES") {
    if (in_array($user_data['usertype'], ['Master Distributor', 'Distributor', 'Retailer'])) {
?>
<div class="row">
    <div class="col-md-4 mb-2">
      <div class="card text-danger">
        <div class="card-header bg-primary text-white py-2">
          <div class="d-flex align-items-center">
            <span class="mr-auto"><?= file_name() ?></span>
            <button class="btn btn-dark btn-sm ml-auto" onclick="history.back()">
              <i class="fas fa-arrow-left"></i> Back
            </button>
          </div>
        </div>
        <div class="p-3 text-dark">
          <?php
          $apiResponseData = null;
          $response = []; // Initialize response array
          $apiKey = "APIKEYPASTEE"; // Buy APi From This Website https://apizone.co.in ( Design & Development By APIZONE )

          // --- 1. CAPTCHA GENERATION LOGIC (On Page Load) ---
          $captchaUrl = "https://kycapizone.in/api/v2/captcha/generation.php";
          $ch_cap = curl_init();
          curl_setopt_array($ch_cap, array(
             CURLOPT_URL => $captchaUrl,
             CURLOPT_RETURNTRANSFER => true,
             CURLOPT_ENCODING => '',
             CURLOPT_MAXREDIRS => 10,
             CURLOPT_TIMEOUT => 30,
             CURLOPT_FOLLOWLOCATION => true,
             CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
             CURLOPT_CUSTOMREQUEST => 'GET',
             CURLOPT_SSL_VERIFYPEER => false,
          ));
          $captchaRespRaw = curl_exec($ch_cap);
          curl_close($ch_cap);
          $responsecaptcha = json_decode($captchaRespRaw, true) ?? [];
          // ----------------------------------------------------

          if (isset($_POST['submit'])) {
              $eidNumber = $_POST['eidNumber'] ?? '';
              $captchaID = $_POST['captchaID'] ?? '';
              $captchacode = $_POST['captchacode'] ?? '';

              if (!empty($eidNumber) && !empty($captchacode)) {
                  $amount = $user_data['enrollment_status_fee'];
                  $old_balance = $user_data['balance'];
                  $new_balance = $old_balance - $amount;

                  if ($old_balance >= $amount) {
                      $order_id = order_txn_id();
                      
                      // --- 2. NEW ENROLLMENT STATUS API IMPLEMENTATION ---
                      $apiUrl = "https://kycapizone.in/api/v2/Aadhar_Advance/enrolmentstatus.php?api_key=" . $apiKey . "&eid=" . $eidNumber . "&captcha=" . $captchacode . "&captcha_txn=" . $captchaID;

                      $curl = curl_init();
                      curl_setopt_array($curl, array(
                         CURLOPT_URL => $apiUrl,
                         CURLOPT_RETURNTRANSFER => true,
                         CURLOPT_ENCODING => '',
                         CURLOPT_MAXREDIRS => 10,
                         CURLOPT_TIMEOUT => 30,
                         CURLOPT_FOLLOWLOCATION => true,
                         CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                         CURLOPT_CUSTOMREQUEST => 'GET',
                         CURLOPT_SSL_VERIFYPEER => false,
                      ));

                      $responseApi = curl_exec($curl);
                      curl_close($curl);
                      
                      $json_data = json_decode($responseApi, true) ?? [];

                      // Check success (Status 100)
                      if (isset($json_data['status']) && $json_data['status'] == '100') {
                          
                          // Map API Result to existing variables
                          $apiResult = $json_data['result'] ?? [];
                          $innerResult = $apiResult['result'] ?? [];
                          
                          $response['status'] = '100';
                          $response['eid'] = $apiResult['eid'] ?? $eidNumber;
                          // Extract the message from the nested result
                          $response['uidMessage'] = $innerResult['resMessage'] ?? 'Status Fetched Successfully';

                          $updateSuccess = db_update("members", ["balance" => $new_balance], "user_id='{$user_data['user_id']}'");

                          if ($updateSuccess) {
                              $insData = [
                                  'site_id'       => $site_data['site_id'],
                                  'user_id'       => $user_data['user_id'],
                                  'username'      => $user_data['username'],
                                  'name'          => $user_data['name'],
                                  'operator'      => $user_data['usertype'],
                                  'parent_id'     => $user_data['parent_id'],
                                  'order_id'      => $order_id,
                                  'service'       => "ENROLLMENT STATUS CHECK",
                                  'type'          => "Debit",
                                  'account_number'=> $eidNumber,
                                  'app_type'      => "ENROLLMENT STATUS CHECK",
                                  'amount'        => $amount,
                                  'main_amount'   => $amount,
                                  'old_balance'   => $old_balance,
                                  'new_balance'   => $new_balance,
                                  'txn_id'        => $order_id,
                                  'ref_id'        => $eidNumber,
                                  'description'   => "Rs.{$amount} Has Been Debit From Wallet for ENROLLMENT STATUS CHECK {$response['uidMessage']} UID Number ",
                                  'date_time'     => current_timestamp(),
                                  'status'        => "Success"
                              ];

                              $insertId = db_insert("reports", $insData);
                              if ($insertId) {
                                  $fields = [
                                      'eid' => 'Enrollment No',
                                      'uidMessage' => 'Message',
                                  ];

                                  $whamessage = "Dear {$user_data['name']},\nYour Request for UID *{$eidNumber}* Verification has been Complete.\n\n";
                                  foreach ($fields as $key => $label) {
                                      if (!empty($response[$key])) {
                                          $whamessage .= "*$label*: {$response[$key]}\n";
                                      }
                                  }
                                  $whamessage .= "\nBest Regards,\n_*{$site_data['brand']}.*_";
                                  send_sms($user_data['mobile'], $whamessage);
                              } else {
                                  awal_alert_msg("Insert Server Error!", 'error');
                              }
                          } else {
                              awal_alert_msg("Balance debited from wallet but not updated in the database. Please contact support!", 'error');
                          }
                      } else {
                          // Handle API Failure
                          $msg = $json_data['message'] ?? 'Server Down or Data Not Found';
                          awal_alert_msg($msg, 'error');
                      }
                      // --- NEW API IMPLEMENTATION END ---

                  } else {
                      awal_alert_msg("Insufficient Wallet Balance!", 'error');
                  }
              } else {
                  awal_alert_msg("Please Fill All Valid Details!", 'error');
              }
          }
          ?>
          <form action="" method="POST" class="row">
            <div class="col-md-12 mb-3">
              <label>Enrollment Number</label>
                <input type="text" name="eidNumber" placeholder="2754***********YYYYMMDD011536" minlength="28" maxlength="28" oninput="this.value=this.value.toUpperCase().replace(/\s+/g,'');this.setCustomValidity(this.value.length<28?'Must be 28 characters':'');" class="form-control" required>
            </div>
            <div class="col-md-12 mb-3">
              <div class="row">
                <div class="col-md-6">
                  <label>Captcha</label>
                  <input type="text" name="captchacode" placeholder="Enter Captcha code" maxlength="10" class="form-control" onkeypress="if(this.value.length==10) return false;" required>
                  <input type="hidden" name="captchaID" value="<?php echo isset($responsecaptcha['txnId']) ? $responsecaptcha['txnId'] : ''; ?>" class="form-control" required>
                </div>
                <div class="col-md-6 d-flex align-items-end">
                <a class="w-100" style="display: block; cursor: pointer;" onclick="location.reload();">
                  <img src="<?php echo isset($responsecaptcha['image']) ? $responsecaptcha['image'] : ''; ?>" alt="Captcha" class="img-fluid" style="height: 38px; width: 100%;">
                </a>
                </div>
              </div>
            </div>
            <div class="col-md-12 mb-3 d-flex justify-content-between">
              <button type="button" class="btn btn-secondary">
                <i class="fas fa-inr"></i> <?= $user_data['enrollment_status_fee']; ?>
              </button>
              <button type="submit" name="submit" class="btn btn-primary" onclick="return confirm('Are you sure?');">Submit</button>
            </div>
          </form>
        </div>
      </div>
    </div>
    <?php if (isset($response['status']) && $response['status'] == '100') {  ?>
    <div class="col-md-8 mb-2">
      <div class="card text-danger">
        <div class="card-header bg-danger text-white py-2">
          <span class="mr-auto">Details Searching Complete EID No: <strong><?= $eidNumber ?? 'N/A'; ?></strong></span>
        </div>
        <div class="table-responsive">
          <table class="table table-bordered table-striped">
            <tbody>
              <?php if (!empty($response['eid'])): ?>
              <tr>
                <td><strong>Eid Number</strong></td>
                <td><?= htmlspecialchars($response['eid']); ?></td>
              </tr>
              <?php endif; ?>
              
              <?php if (!empty($response['uidMessage'])): ?>
              <tr>
                <td><strong>Message</strong></td>
                <td><?= htmlspecialchars($response['uidMessage']); ?></td>
              </tr>
              <?php endif; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
    <?php } ?>
</div>
<?php
} else {
    require_once("404.php");
}
} else {
      awal_alert_msg('You Do Not Have Any Aadhar Service Active!', 'info', 'dashboard');
}
require_once("../layouts/members/foot.php");
?>